export default function About() {
  return (
    <section className="py-20 bg-gray-50">
      <div className="container">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
          <div>
            <h2 className="text-4xl md:text-5xl font-bold text-gray-900 mb-6">
              About Nine Three Merch
            </h2>
            <p className="text-gray-600 mb-4">
              Nine Three Merch LLC is your premier destination for professional auto detailing services and exclusive merchandise. Founded with a passion for automotive excellence, we combine meticulous attention to detail with top-quality products to keep your vehicle looking its absolute best.
            </p>
            <p className="text-gray-600 mb-4">
              With locations in San Antonio, Texas and Roxie, Mississippi, we're committed to serving our communities with exceptional service and unmatched quality. Our team of skilled professionals uses only the finest products and techniques to deliver results that exceed expectations.
            </p>
            <p className="text-gray-600 mb-6">
              Beyond our detailing services, we offer a curated selection of merchandise including branded apparel, professional-grade detailing products, and exclusive accessories that represent the Nine Three lifestyle.
            </p>
            
            <div className="grid grid-cols-2 gap-6 mb-8">
              <div>
                <h3 className="font-bold text-2xl text-red-600 mb-2">100+</h3>
                <p className="text-gray-600">Happy Customers</p>
              </div>
              <div>
                <h3 className="font-bold text-2xl text-red-600 mb-2">2</h3>
                <p className="text-gray-600">Convenient Locations</p>
              </div>
              <div>
                <h3 className="font-bold text-2xl text-red-600 mb-2">5★</h3>
                <p className="text-gray-600">Service Quality</p>
              </div>
              <div>
                <h3 className="font-bold text-2xl text-red-600 mb-2">2025</h3>
                <p className="text-gray-600">Established</p>
              </div>
            </div>
          </div>
          
          <div className="relative">
            <div className="aspect-square rounded-lg bg-gradient-to-br from-gray-900 to-gray-700 p-12">
              <div className="h-full w-full rounded-lg bg-white/10 backdrop-blur flex items-center justify-center">
                <div className="text-center text-white">
                  <h3 className="text-4xl font-bold mb-4">NINE THREE</h3>
                  <p className="text-xl">MERCH LLC</p>
                  <div className="mt-8 space-y-2">
                    <p className="text-sm">EIN: 39-3412571</p>
                    <p className="text-sm">Est. July 25, 2025</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
